/*
 * Decompiled with CFR 0.152.
 */
package mcinterface1201;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import mcinterface1201.BuilderItem;
import mcinterface1201.InterfaceLoader;
import mcinterface1201.WrapperItemStack;
import mcinterface1201.WrapperNBT;
import minecrafttransportsimulator.items.components.AItemBase;
import minecrafttransportsimulator.mcinterface.IInterfaceCore;
import minecrafttransportsimulator.mcinterface.IWrapperItemStack;
import minecrafttransportsimulator.mcinterface.IWrapperNBT;
import minecrafttransportsimulator.mcinterface.InterfaceManager;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;

class InterfaceCore
implements IInterfaceCore {
    protected static final Map<String, List<BuilderItem>> taggedItems = new HashMap<String, List<BuilderItem>>();

    InterfaceCore() {
    }

    @Override
    public boolean isGameFlattened() {
        return true;
    }

    @Override
    public boolean isModPresent(String modID) {
        return ModList.get().isLoaded(modID);
    }

    @Override
    public boolean isFluidValid(String fluidID) {
        for (ResourceLocation location : ForgeRegistries.FLUIDS.getKeys()) {
            if (!location.m_135815_().equals(fluidID)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getModName(String modID) {
        return ((ModContainer)ModList.get().getModContainerById(modID).get()).getModInfo().getDisplayName();
    }

    @Override
    public InputStream getPackResource(String resource) {
        int assetsIndexEnd = resource.indexOf("assets/") + "assets/".length();
        int modIDEnd = resource.indexOf("/", assetsIndexEnd + 1);
        String modID = resource.substring(assetsIndexEnd, modIDEnd);
        Optional optional = ModList.get().getModContainerById(modID);
        if (optional.isPresent()) {
            InputStream stream = ((ModContainer)optional.get()).getMod().getClass().getResourceAsStream(resource);
            if (stream != null) {
                return stream;
            }
            if (modID.equals("mts")) {
                return InterfaceManager.class.getResourceAsStream(resource);
            }
        }
        return Blocks.f_50016_.getClass().getResourceAsStream(resource);
    }

    @Override
    public void logError(String message) {
        InterfaceLoader.LOGGER.error("MTSERROR: " + message);
    }

    @Override
    public IWrapperNBT getNewNBTWrapper() {
        return new WrapperNBT();
    }

    @Override
    public IWrapperItemStack getAutoGeneratedStack(AItemBase item, IWrapperNBT data) {
        WrapperItemStack newStack = new WrapperItemStack(new ItemStack((ItemLike)BuilderItem.itemMap.get(item)));
        newStack.setData(data);
        return newStack;
    }

    @Override
    public IWrapperItemStack getStackForProperties(String name, int meta, int qty) {
        Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)name));
        if (item != null) {
            return new WrapperItemStack(new ItemStack((ItemLike)item, qty));
        }
        return new WrapperItemStack(ItemStack.f_41583_.m_41777_());
    }

    @Override
    public String getStackItemName(IWrapperItemStack stack) {
        return ForgeRegistries.ITEMS.getKey((Object)((WrapperItemStack)stack).stack.m_41720_()).toString();
    }

    @Override
    public boolean isOredictMatch(IWrapperItemStack stackA, IWrapperItemStack stackB) {
        return !((WrapperItemStack)stackA).stack.m_41619_() && ((WrapperItemStack)stackA).stack.m_150930_(((WrapperItemStack)stackB).stack.m_41720_());
    }

    @Override
    public List<IWrapperItemStack> getOredictMaterials(String oreName, int stackSize) {
        List<BuilderItem> items;
        String lowerCaseOre = oreName.toLowerCase(Locale.ROOT);
        ArrayList<IWrapperItemStack> stacks = new ArrayList<IWrapperItemStack>();
        Stream<TagKey> tagStream = BuiltInRegistries.f_257033_.m_203613_().filter(tagKey -> tagKey.f_203868_().m_135815_().equals(lowerCaseOre));
        tagStream.forEach(tagKey -> {
            for (Holder holder : BuiltInRegistries.f_257033_.m_206058_(tagKey)) {
                stacks.add(new WrapperItemStack(new ItemStack((ItemLike)holder.m_203334_(), stackSize)));
            }
        });
        if (stacks.isEmpty() && (items = taggedItems.get(lowerCaseOre)) != null) {
            items.forEach(item -> stacks.add(new WrapperItemStack(new ItemStack((ItemLike)item, stackSize))));
        }
        return stacks;
    }
}

